﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices; //

using hhScale;
namespace csharp_demo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        /*调用C++ DLL 主要有如下几种转换：
        将string转为IntPtr：IntPtr System.Runtime.InteropServices.Marshal.StringToCoTaskMemAuto(string)
        将IntPtr转为string：string System.Runtime.InteropServices.MarshalPtrToStringAuto(IntPtr)
        类型对照：
        BSTR ---------  StringBuilder
        LPCTSTR --------- StringBuilder
        LPCWSTR ---------  IntPtr
        handle---------IntPtr
        hwnd-----------IntPtr
        char *----------string（仅传入）   StringBuilder (需传出)
        int * -----------ref int
        int &-----------ref int
        void *----------IntPtr
        unsigned char *-----ref byte
         * */

        [DllImport("TransferScale.dll", EntryPoint = "TestCallFun", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Winapi)]
         public static extern int TestCallFun(int a, int b, string c);

        [DllImport("TransferScale.dll", EntryPoint = "TestShowForm", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Winapi)]
        public static extern int TestShowForm();

        [DllImport("TransferScale.dll", EntryPoint = "RecvDataFromScale", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Winapi)]
        public static extern int RecvDataFromScale(int ScaleNo, int DataType, int FromNo, int ToNo, string DestFileName);
        
        [DllImport("TransferScale.dll", EntryPoint = "SendDataToScale", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Winapi)]
        public static extern int  SendDataToScale(string ScaleNoList, int DataType, string DataFileName,int DataFormat);
        
        [DllImport("TransferScale.dll", EntryPoint = "DeleteDataFromScale", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Winapi)]
         public static extern int  DeleteDataFromScale(string ScaleNoList, int DataType, int FromNo, int ToNo);

        private void btnCallTest1_Click(object sender, EventArgs e)
        {
            //
            TestCallFun(12, 23, "abc");
        }

        private void btnCallTest2_Click(object sender, EventArgs e)
        {
            //
            TestShowForm();
        }

        private int TryStrToInt(string str)
        {
            int ret = 0;
            try 
            {
                ret = int.Parse(str); 
            }
            catch (Exception e) 
            {
            }
            return ret;
        }

        private void btnSend_Click(object sender, EventArgs e)
        {
            //
            String ScaleNoList = edtScaleNo1.Text.Trim();
            String DataFileName = edtFileName1.Text.Trim();
            int DataType = TryStrToInt( cboDataType1.Text);

            int DataFormat = cboDataFormat.Items.IndexOf(cboDataFormat.Text);
            if (DataFormat < 0)
            {
                edtResult.Text = "Data file format selection error!";
                return;
            }

            edtResult.Clear();
            int Ret = SendDataToScale(ScaleNoList, DataType, DataFileName, DataFormat);

            edtResult.Text = Ret.ToString();
        }

        private void btnRecv_Click(object sender, EventArgs e)
        {
            //
            int ScaleNo = 0;
            int DataType = 0;
            int FromNo = 0;
            int ToNo = 0;
            ScaleNo = TryStrToInt(edtScaleNo2.Text);
            DataType = TryStrToInt(cboDataType2.Text);
            string DestFileName = edtFileName2.Text.Trim();
            FromNo =  TryStrToInt(edtSt2.Text );
            ToNo = TryStrToInt(edtTo2.Text);

            edtResult.Clear();
            int Ret = RecvDataFromScale(ScaleNo, DataType, FromNo, ToNo, DestFileName);

            edtResult.Text = Ret.ToString();
        }

        private void btnDel_Click(object sender, EventArgs e)
        {
            //
            int DataType = 0;
            int FromNo = 0;
            int ToNo = 0;
            string ScaleNoList = edtScaleNo3.Text.Trim();
            DataType = TryStrToInt(cboDataType3.Text.Trim());
            FromNo  = TryStrToInt(edtSt3.Text.Trim());
            ToNo = TryStrToInt(edtTo3.Text.Trim());

            edtResult.Clear();
            int Ret = DeleteDataFromScale(ScaleNoList, DataType, FromNo, ToNo);

            edtResult.Text = Ret.ToString();
        }
        static HuihongBarcodeScale1800 test;
        private void button1_Click(object sender, EventArgs e)
        {
            if(test==null)  test= new HuihongBarcodeScale1800();
            test.Upload("11", 22, true);
        }
    }
}
